/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.http.server;

import java.io.CharConversionException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.security.Principal;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.Subject;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.ThreadCache;
import org.glassfish.grizzly.filterchain.FilterChainContext;
import org.glassfish.grizzly.http.Cookie;
import org.glassfish.grizzly.http.Cookies;
import org.glassfish.grizzly.http.HttpRequestPacket;
import org.glassfish.grizzly.http.Method;
import org.glassfish.grizzly.http.Note;
import org.glassfish.grizzly.http.Protocol;
import org.glassfish.grizzly.http.io.InputBuffer;
import org.glassfish.grizzly.http.io.NIOInputStream;
import org.glassfish.grizzly.http.io.NIOReader;
import org.glassfish.grizzly.http.server.AfterServiceListener;
import org.glassfish.grizzly.http.server.GrizzlyPrincipal;
import org.glassfish.grizzly.http.server.HttpServerFilter;
import org.glassfish.grizzly.http.server.LegacyLocaleParser;
import org.glassfish.grizzly.http.server.LocaleParser;
import org.glassfish.grizzly.http.server.NIOInputStreamImpl;
import org.glassfish.grizzly.http.server.NIOReaderImpl;
import org.glassfish.grizzly.http.server.RequestExecutorProvider;
import org.glassfish.grizzly.http.server.Response;
import org.glassfish.grizzly.http.server.ServerFilterConfiguration;
import org.glassfish.grizzly.http.server.Session;
import org.glassfish.grizzly.http.server.io.ServerInputBuffer;
import org.glassfish.grizzly.http.server.util.MappingData;
import org.glassfish.grizzly.http.server.util.ParameterMap;
import org.glassfish.grizzly.http.server.util.RequestUtils;
import org.glassfish.grizzly.http.server.util.SimpleDateFormats;
import org.glassfish.grizzly.http.server.util.StringParser;
import org.glassfish.grizzly.http.util.Chunk;
import org.glassfish.grizzly.http.util.Constants;
import org.glassfish.grizzly.http.util.DataChunk;
import org.glassfish.grizzly.http.util.FastHttpDateFormat;
import org.glassfish.grizzly.http.util.Header;
import org.glassfish.grizzly.http.util.Parameters;
import org.glassfish.grizzly.localization.LogMessages;
import org.glassfish.grizzly.utils.Charsets;
import org.glassfish.grizzly.utils.DataStructures;
import org.glassfish.grizzly.utils.JdkVersion;

public class Request {
    private static final Logger LOGGER = Grizzly.logger(Request.class);
    private static final Random RANDOM = new Random();
    private static final ThreadCache.CachedTypeIndex<Request> CACHE_IDX = ThreadCache.obtainIndex(Request.class, 16);
    private static LocaleParser localeParser;
    public static final String SEND_FILE_ENABLED_ATTR = "org.glassfish.grizzly.http.SEND_FILE_ENABLED";
    public static final String SEND_FILE_ATTR = "org.glassfish.grizzly.http.SEND_FILE";
    public static final String SEND_FILE_START_OFFSET_ATTR = "org.glassfish.grizzly.http.FILE_START_OFFSET";
    public static final String SEND_FILE_WRITE_LEN_ATTR = "org.glassfish.grizzly.http.FILE_WRITE_LEN";
    private static final String match = ";jsessionid=";
    private static final Map<String, Session> SESSIONS;
    private static final ScheduledThreadPoolExecutor SESSION_EXPIRER;
    protected HttpRequestPacket request;
    protected FilterChainContext ctx;
    protected HttpServerFilter httpServerFilter;
    protected final List<AfterServiceListener> afterServicesList = new ArrayList<AfterServiceListener>(4);
    private Session session;
    private String scheme;
    private final PathData contextPath = new PathData(this, "", null);
    private final PathData httpHandlerPath = new PathData(this);
    private final PathData pathInfo = new PathData(this);
    private MappingData cachedMappingData;
    protected Cookie[] cookies = null;
    protected Cookies rawCookies;
    protected static final Locale defaultLocale;
    protected final ArrayList<Locale> locales = new ArrayList();
    protected Object dispatcherType = null;
    protected final ServerInputBuffer inputBuffer = new ServerInputBuffer();
    private final NIOInputStreamImpl inputStream = new NIOInputStreamImpl();
    private final NIOReaderImpl reader = new NIOReaderImpl();
    protected boolean usingInputStream = false;
    protected boolean usingReader = false;
    protected Principal userPrincipal = null;
    protected boolean sessionParsed = false;
    protected boolean requestParametersParsed = false;
    protected boolean cookiesParsed = false;
    protected boolean secure = false;
    protected Subject subject = null;
    protected final ParameterMap parameterMap = new ParameterMap();
    protected final Parameters parameters = new Parameters();
    protected Object requestDispatcherPath = null;
    protected boolean requestedSessionCookie = false;
    protected String requestedSessionId = null;
    protected boolean requestedSessionURL = false;
    protected boolean localesParsed = false;
    private StringParser parser;
    private int dispatchDepth = 0;
    private static int maxDispatchDepth;
    private String jrouteId;
    private RequestExecutorProvider requestExecutorProvider;
    protected final Response response;

    public static Request create() {
        Request request = ThreadCache.takeFromCache(CACHE_IDX);
        if (request != null) {
            return request;
        }
        return new Request(new Response());
    }

    public final MappingData obtainMappingData() {
        if (this.cachedMappingData == null) {
            this.cachedMappingData = new MappingData();
        }
        return this.cachedMappingData;
    }

    protected Request(Response response) {
        this.response = response;
    }

    public void initialize(HttpRequestPacket request, FilterChainContext ctx, HttpServerFilter httpServerFilter) {
        this.request = request;
        this.ctx = ctx;
        this.httpServerFilter = httpServerFilter;
        this.inputBuffer.initialize(this, ctx);
        this.parameters.setHeaders(request.getHeaders());
        this.parameters.setQuery(request.getQueryStringDC());
        DataChunk remoteUser = request.remoteUser();
        if (!remoteUser.isNull()) {
            this.setUserPrincipal(new GrizzlyPrincipal(remoteUser.toString()));
        }
        if (httpServerFilter != null) {
            ServerFilterConfiguration configuration = httpServerFilter.getConfiguration();
            this.parameters.setQueryStringEncoding(configuration.getDefaultQueryEncoding());
            String overridingScheme = configuration.getScheme();
            this.scheme = overridingScheme != null ? overridingScheme : (request.isSecure() ? "https" : "http");
        } else {
            this.scheme = request.isSecure() ? "https" : "http";
        }
    }

    final HttpServerFilter getServerFilter() {
        return this.httpServerFilter;
    }

    public HttpRequestPacket getRequest() {
        return this.request;
    }

    public Response getResponse() {
        return this.response;
    }

    public Executor getRequestExecutor() {
        return this.requestExecutorProvider.getExecutor(this);
    }

    protected void setRequestExecutorProvider(RequestExecutorProvider requestExecutorProvider) {
        this.requestExecutorProvider = requestExecutorProvider;
    }

    public void addAfterServiceListener(AfterServiceListener listener) {
        this.afterServicesList.add(listener);
    }

    public void removeAfterServiceListener(AfterServiceListener listener) {
        this.afterServicesList.remove(listener);
    }

    protected void onAfterService() {
        if (!this.inputBuffer.isFinished()) {
            this.inputBuffer.terminate();
        }
        if (!this.afterServicesList.isEmpty()) {
            int size2 = this.afterServicesList.size();
            for (int i = 0; i < size2; ++i) {
                AfterServiceListener anAfterServicesList = this.afterServicesList.get(i);
                try {
                    anAfterServicesList.onAfterService(this);
                    continue;
                }
                catch (Exception e) {
                    LOGGER.log(Level.WARNING, LogMessages.WARNING_GRIZZLY_HTTP_SERVER_REQUEST_AFTERSERVICE_NOTIFICATION_ERROR(), e);
                }
            }
        }
    }

    protected void recycle() {
        this.scheme = null;
        this.contextPath.setPath("");
        this.httpHandlerPath.reset();
        this.pathInfo.reset();
        this.dispatcherType = null;
        this.requestDispatcherPath = null;
        this.inputBuffer.recycle();
        this.inputStream.recycle();
        this.reader.recycle();
        this.usingInputStream = false;
        this.usingReader = false;
        this.userPrincipal = null;
        this.subject = null;
        this.sessionParsed = false;
        this.requestParametersParsed = false;
        this.cookiesParsed = false;
        if (this.rawCookies != null) {
            this.rawCookies.recycle();
        }
        this.locales.clear();
        this.localesParsed = false;
        this.secure = false;
        this.request.recycle();
        this.request = null;
        this.ctx = null;
        this.httpServerFilter = null;
        this.cookies = null;
        this.requestedSessionId = null;
        this.session = null;
        this.dispatchDepth = 0;
        this.parameterMap.setLocked(false);
        this.parameterMap.clear();
        this.parameters.recycle();
        this.requestExecutorProvider = null;
        this.afterServicesList.clear();
        if (this.cachedMappingData != null) {
            this.cachedMappingData.recycle();
        }
        ThreadCache.putToCache(CACHE_IDX, this);
    }

    public String getAuthorization() {
        return this.request.getHeader("authorization");
    }

    public void replayPayload(Buffer buffer) {
        this.inputBuffer.replayPayload(buffer);
        this.usingReader = false;
        this.usingInputStream = false;
        if (Method.POST.equals(this.getMethod()) && this.requestParametersParsed) {
            this.requestParametersParsed = false;
            this.parameterMap.setLocked(false);
            this.parameterMap.clear();
            this.parameters.recycle();
        }
    }

    public NIOInputStream createInputStream() {
        this.inputStream.setInputBuffer(this.inputBuffer);
        return this.inputStream;
    }

    public static <E> Note<E> createNote(String name) {
        return HttpRequestPacket.createNote(name);
    }

    public <E> E getNote(Note<E> note) {
        return this.request.getNote(note);
    }

    public Set<String> getNoteNames() {
        return this.request.getNoteNames();
    }

    public <E> E removeNote(Note<E> note) {
        return this.request.removeNote(note);
    }

    public <E> void setNote(Note<E> note, E value2) {
        this.request.setNote(note, value2);
    }

    public void setServerName(String name) {
        this.request.serverName().setString(name);
    }

    public void setServerPort(int port) {
        this.request.setServerPort(port);
    }

    public HttpServerFilter getHttpFilter() {
        return this.httpServerFilter;
    }

    public String getContextPath() {
        return this.contextPath.get();
    }

    protected void setContextPath(String contextPath) {
        this.contextPath.setPath(contextPath);
    }

    protected void setContextPath(PathResolver contextPath) {
        this.contextPath.setResolver(contextPath);
    }

    public String getHttpHandlerPath() {
        return this.httpHandlerPath.get();
    }

    protected void setHttpHandlerPath(String httpHandlerPath) {
        this.httpHandlerPath.setPath(httpHandlerPath);
    }

    protected void setHttpHandlerPath(PathResolver httpHandlerPath) {
        this.httpHandlerPath.setResolver(httpHandlerPath);
    }

    public String getPathInfo() {
        return this.pathInfo.get();
    }

    protected void setPathInfo(String pathInfo) {
        this.pathInfo.setPath(pathInfo);
    }

    protected void setPathInfo(PathResolver pathInfo) {
        this.pathInfo.setResolver(pathInfo);
    }

    public Object getAttribute(String name) {
        if (SEND_FILE_ENABLED_ATTR.equals(name)) {
            return this.response.isSendFileEnabled();
        }
        Object attribute2 = this.request.getAttribute(name);
        if (attribute2 != null) {
            return attribute2;
        }
        if ("org.apache.coyote.request.X509Certificate".equals(name)) {
            attribute2 = RequestUtils.populateCertificateAttribute(this);
            if (attribute2 != null) {
                this.request.setAttribute(name, attribute2);
            }
        } else if (Request.isSSLAttribute(name)) {
            RequestUtils.populateSSLAttributes(this);
            attribute2 = this.request.getAttribute(name);
        } else if ("org.apache.catalina.core.DISPATCHER_REQUEST_PATH".equals(name)) {
            return this.requestDispatcherPath;
        }
        return attribute2;
    }

    static boolean isSSLAttribute(String name) {
        return "javax.servlet.request.X509Certificate".equals(name) || "javax.servlet.request.cipher_suite".equals(name) || "javax.servlet.request.key_size".equals(name);
    }

    public Set<String> getAttributeNames() {
        return this.request.getAttributeNames();
    }

    public String getCharacterEncoding() {
        return this.request.getCharacterEncoding();
    }

    public int getContentLength() {
        return (int)this.request.getContentLength();
    }

    public long getContentLengthLong() {
        return this.request.getContentLength();
    }

    public String getContentType() {
        return this.request.getContentType();
    }

    public InputStream getInputStream() {
        return this.getNIOInputStream();
    }

    public NIOInputStream getNIOInputStream() {
        if (this.usingReader) {
            throw new IllegalStateException("Illegal attempt to call getInputStream() after getReader() has already been called.");
        }
        this.usingInputStream = true;
        this.inputStream.setInputBuffer(this.inputBuffer);
        return this.inputStream;
    }

    public boolean asyncInput() {
        return this.inputBuffer.isAsyncEnabled();
    }

    public boolean requiresAcknowledgement() {
        return this.request.requiresAcknowledgement();
    }

    public Locale getLocale() {
        if (!this.localesParsed) {
            this.parseLocales();
        }
        if (!this.locales.isEmpty()) {
            return this.locales.get(0);
        }
        return defaultLocale;
    }

    public List<Locale> getLocales() {
        if (!this.localesParsed) {
            this.parseLocales();
        }
        if (!this.locales.isEmpty()) {
            return this.locales;
        }
        ArrayList<Locale> results = new ArrayList<Locale>();
        results.add(defaultLocale);
        return results;
    }

    public Parameters getParameters() {
        return this.parameters;
    }

    public String getParameter(String name) {
        if (!this.requestParametersParsed) {
            this.parseRequestParameters();
        }
        return this.parameters.getParameter(name);
    }

    public Map<String, String[]> getParameterMap() {
        if (this.parameterMap.isLocked()) {
            return this.parameterMap;
        }
        for (String name : this.getParameterNames()) {
            String[] values2 = this.getParameterValues(name);
            this.parameterMap.put(name, values2);
        }
        this.parameterMap.setLocked(true);
        return this.parameterMap;
    }

    public Set<String> getParameterNames() {
        if (!this.requestParametersParsed) {
            this.parseRequestParameters();
        }
        return this.parameters.getParameterNames();
    }

    public String[] getParameterValues(String name) {
        if (!this.requestParametersParsed) {
            this.parseRequestParameters();
        }
        return this.parameters.getParameterValues(name);
    }

    public Protocol getProtocol() {
        return this.request.getProtocol();
    }

    public Reader getReader() {
        return this.getNIOReader();
    }

    public NIOReader getNIOReader() {
        if (this.usingInputStream) {
            throw new IllegalStateException("Illegal attempt to call getReader() after getInputStream() has alread been called.");
        }
        this.usingReader = true;
        this.inputBuffer.processingChars();
        this.reader.setInputBuffer(this.inputBuffer);
        return this.reader;
    }

    public String getRemoteAddr() {
        return this.request.getRemoteAddress();
    }

    public String getRemoteHost() {
        return this.request.getRemoteHost();
    }

    public int getRemotePort() {
        return this.request.getRemotePort();
    }

    public String getLocalName() {
        return this.request.getLocalName();
    }

    public String getLocalAddr() {
        return this.request.getLocalAddress();
    }

    public int getLocalPort() {
        return this.request.getLocalPort();
    }

    public String getScheme() {
        return this.scheme;
    }

    public String getServerName() {
        return this.request.serverName().toString();
    }

    public int getServerPort() {
        return this.request.getServerPort();
    }

    public boolean isSecure() {
        return this.request.isSecure();
    }

    public void removeAttribute(String name) {
        this.request.removeAttribute(name);
    }

    public void setAttribute(String name, Object value2) {
        if (name == null) {
            throw new IllegalArgumentException("Argument 'name' cannot be null");
        }
        if (value2 == null) {
            this.removeAttribute(name);
            return;
        }
        if (name.equals("org.apache.catalina.core.DISPATCHER_TYPE")) {
            this.dispatcherType = value2;
            return;
        }
        if (name.equals("org.apache.catalina.core.DISPATCHER_REQUEST_PATH")) {
            this.requestDispatcherPath = value2;
            return;
        }
        this.request.setAttribute(name, value2);
        if (this.response.isSendFileEnabled() && SEND_FILE_ATTR.equals(name)) {
            RequestUtils.handleSendFile(this);
        }
    }

    public void setCharacterEncoding(String encoding) throws UnsupportedEncodingException {
        if (this.requestParametersParsed || this.usingReader) {
            return;
        }
        Charsets.lookupCharset(encoding);
        this.request.setCharacterEncoding(encoding);
    }

    public static void setMaxDispatchDepth(int depth) {
        maxDispatchDepth = depth;
    }

    public static int getMaxDispatchDepth() {
        return maxDispatchDepth;
    }

    public int incrementDispatchDepth() {
        return ++this.dispatchDepth;
    }

    public int decrementDispatchDepth() {
        return --this.dispatchDepth;
    }

    public boolean isMaxDispatchDepthReached() {
        return this.dispatchDepth > maxDispatchDepth;
    }

    public void addCookie(Cookie cookie) {
        if (!this.cookiesParsed) {
            this.parseCookies();
        }
        int size2 = 0;
        if (cookie != null) {
            size2 = this.cookies.length;
        }
        Cookie[] newCookies = new Cookie[size2 + 1];
        System.arraycopy(this.cookies, 0, newCookies, 0, size2);
        newCookies[size2] = cookie;
        this.cookies = newCookies;
    }

    public void addLocale(Locale locale) {
        this.locales.add(locale);
    }

    public void addParameter(String name, String[] values2) {
        this.parameters.addParameterValues(name, values2);
    }

    public void clearCookies() {
        this.cookiesParsed = true;
        this.cookies = null;
    }

    public void clearHeaders() {
    }

    public void clearLocales() {
        this.locales.clear();
    }

    public void clearParameters() {
    }

    public String getDecodedRequestURI() throws CharConversionException {
        return this.request.getRequestURIRef().getDecodedURI();
    }

    public void setUserPrincipal(Principal principal) {
        this.userPrincipal = principal;
    }

    public String getAuthType() {
        return this.request.authType().toString();
    }

    public Cookie[] getCookies() {
        if (!this.cookiesParsed) {
            this.parseCookies();
        }
        return this.cookies;
    }

    public void setCookies(Cookie[] cookies) {
        this.cookies = cookies;
    }

    public long getDateHeader(String name) {
        String value2 = this.getHeader(name);
        if (value2 == null) {
            return -1L;
        }
        SimpleDateFormats formats = SimpleDateFormats.create();
        try {
            long result2 = FastHttpDateFormat.parseDate(value2, formats.getFormats());
            if (result2 != -1L) {
                long l = result2;
                return l;
            }
            throw new IllegalArgumentException(value2);
        }
        finally {
            formats.recycle();
        }
    }

    public long getDateHeader(Header header) {
        String value2 = this.getHeader(header);
        if (value2 == null) {
            return -1L;
        }
        SimpleDateFormats formats = SimpleDateFormats.create();
        try {
            long result2 = FastHttpDateFormat.parseDate(value2, formats.getFormats());
            if (result2 != -1L) {
                long l = result2;
                return l;
            }
            throw new IllegalArgumentException(value2);
        }
        finally {
            formats.recycle();
        }
    }

    public String getHeader(String name) {
        return this.request.getHeader(name);
    }

    public String getHeader(Header header) {
        return this.request.getHeader(header);
    }

    public Iterable<String> getHeaders(String name) {
        return this.request.getHeaders().values(name);
    }

    public Iterable<String> getHeaders(Header header) {
        return this.request.getHeaders().values(header);
    }

    public Iterable<String> getHeaderNames() {
        return this.request.getHeaders().names();
    }

    public int getIntHeader(String name) {
        String value2 = this.getHeader(name);
        if (value2 == null) {
            return -1;
        }
        return Integer.parseInt(value2);
    }

    public int getIntHeader(Header header) {
        String value2 = this.getHeader(header);
        if (value2 == null) {
            return -1;
        }
        return Integer.parseInt(value2);
    }

    public Method getMethod() {
        return this.request.getMethod();
    }

    public void setMethod(String method2) {
        this.request.setMethod(method2);
    }

    public String getQueryString() {
        String queryString = this.request.getQueryString();
        if (queryString == null || queryString.isEmpty()) {
            return null;
        }
        return queryString;
    }

    public void setQueryString(String queryString) {
        this.request.setQueryString(queryString);
    }

    public String getRemoteUser() {
        if (this.userPrincipal != null) {
            return this.userPrincipal.getName();
        }
        return null;
    }

    public String getRequestedSessionId() {
        return this.requestedSessionId;
    }

    public String getRequestURI() {
        return this.request.getRequestURI();
    }

    public void setRequestURI(String uri) {
        this.request.setRequestURI(uri);
    }

    public StringBuilder getRequestURL() {
        StringBuilder url = new StringBuilder();
        return Request.appendRequestURL(this, url);
    }

    public static StringBuilder appendRequestURL(Request request, StringBuilder buffer) {
        String scheme = request.getScheme();
        int port = request.getServerPort();
        if (port < 0) {
            port = 80;
        }
        buffer.append(scheme);
        buffer.append("://");
        buffer.append(request.getServerName());
        if (scheme.equals("http") && port != 80 || scheme.equals("https") && port != 443) {
            buffer.append(':');
            buffer.append(port);
        }
        buffer.append(request.getRequestURI());
        return buffer;
    }

    public static StringBuffer appendRequestURL(Request request, StringBuffer buffer) {
        String scheme = request.getScheme();
        int port = request.getServerPort();
        if (port < 0) {
            port = 80;
        }
        buffer.append(scheme);
        buffer.append("://");
        buffer.append(request.getServerName());
        if (scheme.equals("http") && port != 80 || scheme.equals("https") && port != 443) {
            buffer.append(':');
            buffer.append(port);
        }
        buffer.append(request.getRequestURI());
        return buffer;
    }

    public Principal getUserPrincipal() {
        if (this.userPrincipal == null && this.getRequest().isSecure()) {
            X509Certificate[] certs = (X509Certificate[])this.getAttribute("javax.servlet.request.X509Certificate");
            if (certs == null || certs.length < 1) {
                certs = (X509Certificate[])this.getAttribute("org.apache.coyote.request.X509Certificate");
            }
            if (certs != null && certs.length > 0) {
                this.userPrincipal = certs[0].getSubjectX500Principal();
            }
        }
        return this.userPrincipal;
    }

    public FilterChainContext getContext() {
        return this.ctx;
    }

    protected String unescape(String s2) {
        if (s2 == null) {
            return null;
        }
        if (s2.indexOf(92) == -1) {
            return s2;
        }
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < s2.length(); ++i) {
            char c = s2.charAt(i);
            if (c != '\\') {
                buf.append(c);
                continue;
            }
            if (++i >= s2.length()) {
                throw new IllegalArgumentException();
            }
            c = s2.charAt(i);
            buf.append(c);
        }
        return buf.toString();
    }

    protected void parseCookies() {
        this.cookiesParsed = true;
        Cookies serverCookies = this.getRawCookies();
        this.cookies = serverCookies.get();
    }

    public InputBuffer getInputBuffer() {
        return this.inputBuffer;
    }

    public void setRequestParameters(Parameters parameters) {
        this.requestParametersParsed = true;
        for (String name : parameters.getParameterNames()) {
            this.parameters.addParameterValues(name, parameters.getParameterValues(name));
        }
    }

    protected Cookies getRawCookies() {
        if (this.rawCookies == null) {
            this.rawCookies = new Cookies();
        }
        if (!this.rawCookies.initialized()) {
            this.rawCookies.setHeaders(this.request.getHeaders());
        }
        return this.rawCookies;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void parseRequestParameters() {
        this.requestParametersParsed = true;
        Charset charset = null;
        if (this.parameters.getEncoding() == null) {
            charset = this.lookupCharset(this.getCharacterEncoding());
            this.parameters.setEncoding(charset);
        }
        if (this.parameters.getQueryStringEncoding() == null) {
            if (charset == null) {
                charset = this.lookupCharset(this.getCharacterEncoding());
            }
            this.parameters.setQueryStringEncoding(charset);
        }
        this.parameters.handleQueryParameters();
        if (this.usingInputStream || this.usingReader) {
            return;
        }
        if (!Method.POST.equals(this.getMethod())) {
            return;
        }
        if (!this.checkPostContentType(this.getContentType())) {
            return;
        }
        int maxFormPostSize = this.httpServerFilter.getConfiguration().getMaxFormPostSize();
        int len = this.getContentLength();
        if (len < 0) {
            if (!this.request.isChunked()) {
                return;
            }
            len = maxFormPostSize;
        }
        if (maxFormPostSize > 0 && len > maxFormPostSize) {
            if (LOGGER.isLoggable(Level.WARNING)) {
                LOGGER.warning(LogMessages.WARNING_GRIZZLY_HTTP_SERVER_REQUEST_POST_TOO_LARGE());
            }
            throw new IllegalStateException(LogMessages.WARNING_GRIZZLY_HTTP_SERVER_REQUEST_POST_TOO_LARGE());
        }
        int read2 = 0;
        try {
            Buffer formData = this.getPostBody(len);
            read2 = formData.remaining();
            this.parameters.processParameters(formData, formData.position(), read2);
        }
        catch (Exception ignored) {
        }
        finally {
            try {
                this.skipPostBody(read2);
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, LogMessages.WARNING_GRIZZLY_HTTP_SERVER_REQUEST_BODY_SKIP(), e);
            }
        }
    }

    private Charset lookupCharset(String enc) {
        Charset charset;
        if (enc != null) {
            try {
                charset = Charsets.lookupCharset(enc);
            }
            catch (Exception e) {
                charset = Constants.DEFAULT_HTTP_CHARSET;
            }
        } else {
            charset = Constants.DEFAULT_HTTP_CHARSET;
        }
        return charset;
    }

    private boolean checkPostContentType(String contentType) {
        return contentType != null && contentType.trim().startsWith("application/x-www-form-urlencoded");
    }

    public Buffer getPostBody(int len) throws IOException {
        this.inputBuffer.fillFully(len);
        return this.inputBuffer.getBuffer();
    }

    protected void skipPostBody(int len) throws IOException {
        this.inputBuffer.skip(len);
    }

    protected void parseLocales() {
        this.localesParsed = true;
        Iterable<String> values2 = this.getHeaders("accept-language");
        for (String value2 : values2) {
            this.parseLocalesHeader(value2);
        }
    }

    protected void parseLocalesHeader(String value2) {
        int start;
        TreeMap<Double, ArrayList<Locale>> localLocalesMap = new TreeMap<Double, ArrayList<Locale>>();
        int white = value2.indexOf(32);
        if (white < 0) {
            white = value2.indexOf(9);
        }
        if (white >= 0) {
            int len = value2.length();
            StringBuilder sb = new StringBuilder(len - 1);
            for (int i = 0; i < len; ++i) {
                char ch = value2.charAt(i);
                if (ch == ' ' || ch == '\t') continue;
                sb.append(ch);
            }
            value2 = sb.toString();
        }
        if (this.parser == null) {
            this.parser = new StringParser();
        }
        this.parser.setString(value2);
        int length = this.parser.getLength();
        while ((start = this.parser.getIndex()) < length) {
            Locale locale;
            int end = this.parser.findChar(',');
            String entry2 = this.parser.extract(start, end).trim();
            this.parser.advance();
            double quality = 1.0;
            int semi = entry2.indexOf(";q=");
            if (semi >= 0) {
                String qvalue = entry2.substring(semi + 3);
                if (qvalue.length() <= 5) {
                    try {
                        quality = Double.parseDouble(qvalue);
                    }
                    catch (NumberFormatException e) {
                        quality = 0.0;
                    }
                } else {
                    quality = 0.0;
                }
                entry2 = entry2.substring(0, semi);
            }
            if (quality < 5.0E-5 || "*".equals(entry2) || (locale = localeParser.parseLocale(entry2)) == null) continue;
            Double key = -quality;
            ArrayList<Locale> values2 = (ArrayList<Locale>)localLocalesMap.get(key);
            if (values2 == null) {
                values2 = new ArrayList<Locale>();
                localLocalesMap.put(key, values2);
            }
            values2.add(locale);
        }
        for (List localLocales : localLocalesMap.values()) {
            for (Locale locale : localLocales) {
                this.addLocale(locale);
            }
        }
    }

    void parseJrouteCookie() {
        Cookie cookie;
        if (!this.cookiesParsed) {
            this.parseCookies();
        }
        if ((cookie = this.getRawCookies().findByName("JROUTE")) != null) {
            this.setJrouteId(cookie.getValue());
        }
    }

    static boolean isAlpha(String value2) {
        if (value2 == null) {
            return false;
        }
        for (int i = 0; i < value2.length(); ++i) {
            char c = value2.charAt(i);
            if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z') continue;
            return false;
        }
        return true;
    }

    void setJrouteId(String jrouteId) {
        this.jrouteId = jrouteId;
    }

    public String getJrouteId() {
        return this.jrouteId;
    }

    public Session getSession() {
        return this.doGetSession(true);
    }

    public Session getSession(boolean create2) {
        return this.doGetSession(create2);
    }

    public String changeSessionId() {
        Session sessionLocal = this.doGetSession(false);
        if (sessionLocal == null) {
            throw new IllegalStateException("changeSessionId has been called without a session");
        }
        String oldSessionId = sessionLocal.getIdInternal();
        String newSessionId = String.valueOf(Request.generateRandomLong());
        sessionLocal.setIdInternal(newSessionId);
        if (this.requestedSessionId != null && this.requestedSessionId.length() > 0) {
            this.requestedSessionId = newSessionId;
        }
        SESSIONS.remove(oldSessionId);
        SESSIONS.put(newSessionId, this.session);
        if (this.isRequestedSessionIdFromURL()) {
            return oldSessionId;
        }
        if (this.response != null) {
            Cookie cookie = new Cookie("JSESSIONID", sessionLocal.getIdInternal());
            this.configureSessionCookie(cookie);
            this.response.addSessionCookieInternal(cookie);
        }
        return oldSessionId;
    }

    protected Session doGetSession(boolean create2) {
        if (this.session != null && !this.session.isValid()) {
            this.session = null;
        }
        if (this.session != null) {
            return this.session;
        }
        if (this.requestedSessionId == null) {
            Cookie[] cookiesLocale = this.getCookies();
            assert (cookiesLocale != null);
            for (int i = 0; i < cookiesLocale.length; ++i) {
                Cookie c = cookiesLocale[i];
                if (!"JSESSIONID".equals(c.getName())) continue;
                this.setRequestedSessionId(c.getValue());
                this.setRequestedSessionCookie(true);
                break;
            }
        }
        if (this.requestedSessionId != null) {
            this.session = SESSIONS.get(this.requestedSessionId);
            if (this.session != null && !this.session.isValid()) {
                this.session = null;
            }
            if (this.session != null) {
                return this.session;
            }
        }
        if (!create2) {
            return null;
        }
        if (this.requestedSessionId != null && this.httpServerFilter.getConfiguration().isReuseSessionID()) {
            this.session = new Session(this.requestedSessionId);
        } else {
            this.requestedSessionId = String.valueOf(Request.generateRandomLong());
            this.session = new Session(this.requestedSessionId);
        }
        SESSIONS.put(this.requestedSessionId, this.session);
        if (this.session != null) {
            Cookie cookie = new Cookie("JSESSIONID", this.session.getIdInternal());
            this.configureSessionCookie(cookie);
            this.response.addCookie(cookie);
        }
        if (this.session != null) {
            return this.session;
        }
        return null;
    }

    public boolean isRequestedSessionIdFromCookie() {
        return this.requestedSessionId != null && this.requestedSessionCookie;
    }

    public boolean isRequestedSessionIdFromURL() {
        return this.requestedSessionId != null && this.requestedSessionURL;
    }

    public boolean isRequestedSessionIdValid() {
        if (this.requestedSessionId == null) {
            return false;
        }
        if (this.session != null && this.requestedSessionId.equals(this.session.getIdInternal())) {
            return this.session.isValid();
        }
        Session localSession = SESSIONS.get(this.requestedSessionId);
        return localSession != null && localSession.isValid();
    }

    protected void configureSessionCookie(Cookie cookie) {
        cookie.setMaxAge(-1);
        cookie.setPath("/");
        if (this.isSecure()) {
            cookie.setSecure(true);
        }
    }

    protected void parseSessionId() {
        boolean isUpdated;
        if (this.sessionParsed) {
            return;
        }
        this.sessionParsed = true;
        DataChunk uriDC = this.request.getRequestURIRef().getRequestURIBC();
        switch (uriDC.getType()) {
            case Bytes: {
                isUpdated = this.parseSessionId(uriDC.getByteChunk());
                break;
            }
            case Buffer: {
                isUpdated = this.parseSessionId(uriDC.getBufferChunk());
                break;
            }
            case Chars: {
                isUpdated = this.parseSessionId(uriDC.getCharChunk());
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected DataChunk type: " + (Object)((Object)uriDC.getType()));
            }
        }
        if (isUpdated) {
            uriDC.notifyDirectUpdate();
        }
    }

    private boolean parseSessionId(Chunk uriChunk) {
        boolean isUpdated = false;
        int semicolon = uriChunk.indexOf(match, 0);
        if (semicolon > 0) {
            int sessionIdStart;
            int semicolon2 = uriChunk.indexOf(';', sessionIdStart = semicolon + match.length());
            isUpdated = semicolon2 >= 0;
            int end = isUpdated ? semicolon2 : uriChunk.getLength();
            String sessionId = uriChunk.toString(sessionIdStart, end);
            int jrouteIndex = sessionId.lastIndexOf(58);
            if (jrouteIndex > 0) {
                this.setRequestedSessionId(sessionId.substring(0, jrouteIndex));
                if (jrouteIndex < sessionId.length() - 1) {
                    this.setJrouteId(sessionId.substring(jrouteIndex + 1));
                }
            } else {
                this.setRequestedSessionId(sessionId);
            }
            this.setRequestedSessionURL(true);
            uriChunk.delete(semicolon, end);
        } else {
            this.setRequestedSessionId(null);
            this.setRequestedSessionURL(false);
        }
        return isUpdated;
    }

    public void setRequestedSessionCookie(boolean flag) {
        this.requestedSessionCookie = flag;
    }

    public void setRequestedSessionId(String id) {
        this.requestedSessionId = id;
    }

    public void setRequestedSessionURL(boolean flag) {
        this.requestedSessionURL = flag;
    }

    private static long generateRandomLong() {
        return RANDOM.nextLong() & Long.MAX_VALUE;
    }

    static {
        JdkVersion version = JdkVersion.getJdkVersion();
        if (version.compareTo("1.7.0") >= 0) {
            try {
                Class<?> localeParserClazz = Class.forName("org.glassfish.grizzly.http.server.TagLocaleParser");
                localeParser = (LocaleParser)localeParserClazz.newInstance();
            }
            catch (Exception e) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.FINE, e.toString(), e);
                }
                localeParser = new LegacyLocaleParser();
            }
        }
        SESSIONS = DataStructures.getConcurrentMap();
        SESSION_EXPIRER = new ScheduledThreadPoolExecutor(1, new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread t = new Thread(r, "Grizzly-HttpSession-Expirer");
                t.setDaemon(true);
                return t;
            }
        });
        SESSION_EXPIRER.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                long currentTime = System.currentTimeMillis();
                Iterator iterator2 = SESSIONS.entrySet().iterator();
                while (iterator2.hasNext()) {
                    Map.Entry entry2 = iterator2.next();
                    if (((Session)entry2.getValue()).getSessionTimeout() == -1L || currentTime - ((Session)entry2.getValue()).getTimestamp() <= ((Session)entry2.getValue()).getSessionTimeout()) continue;
                    ((Session)entry2.getValue()).setValid(false);
                    iterator2.remove();
                }
            }
        }, 5L, 5L, TimeUnit.SECONDS);
        defaultLocale = Locale.getDefault();
        maxDispatchDepth = 20;
    }

    protected static interface PathResolver {
        public String resolve(Request var1);
    }

    private static class PathData {
        private final Request request;
        private String path;
        private PathResolver resolver;

        public PathData(Request request) {
            this.request = request;
        }

        public PathData(Request request, String path2, PathResolver resolver) {
            this.request = request;
            this.path = path2;
            this.resolver = resolver;
        }

        public void setPath(String path2) {
            this.path = path2;
            this.resolver = null;
        }

        public void setResolver(PathResolver resolver) {
            this.resolver = resolver;
            this.path = null;
        }

        public String get() {
            return this.path != null ? this.path : (this.resolver != null ? (this.path = this.resolver.resolve(this.request)) : null);
        }

        public void reset() {
            this.path = null;
            this.resolver = null;
        }
    }
}

